
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Find Your Perfect Rental</title>
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css"> <!-- jQuery UI for datepicker -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
    <script src="js/main.js" defer></script>
</head>
<body>
    <div class="container">
        <h1>Find Your Perfect Rental</h1>

        <!-- Search Filters Section -->
        <div class="filter-section">
            <div class="filter-container">
                <!-- Date Range Picker -->
                <input type="text" id="dateRange" placeholder="From - To">
                
                <!-- Town Selection -->
                <select id="town">
                    <option value="">All Towns</option>
                    <option value="Malibu">Malibu</option>
                    <option value="Los Angeles">Los Angeles</option>
                    <!-- Add more towns as needed -->
                </select>
                
                <!-- Adults Selection -->
                <select id="adults">
                    <option value="">Select Adults</option>
                    <option value="1">1</option>
                    <option value="2">2</option>
                    <option value="3">3</option>
                    <option value="4">4</option>
                    <!-- Add more options as needed -->
                </select>
                
                <!-- Bathrooms Selection -->
                <select id="bathrooms">
                    <option value="">Select Bathrooms</option>
                    <option value="1">1</option>
                    <option value="2">2</option>
                    <option value="3">3</option>
                </select>
                
                <!-- Bedrooms Selection -->
                <select id="bedrooms">
                    <option value="">Select Bedrooms</option>
                    <option value="1">1</option>
                    <option value="2">2</option>
                    <option value="3">3</option>
                </select>
                
                <!-- Search Button -->
                <button id="searchBtn">Search</button>
            </div>
        </div>

        <!-- Property List Section -->
        <div class="property-list" id="propertyList">
            <!-- Dynamic content from search results will appear here -->
        </div>
    </div>

    <script>
    // Initialize date range picker
    $(document).ready(function() {
        $("#dateRange").datepicker({
            dateFormat: "dd-mm-yy",
            changeMonth: true,
            changeYear: true,
            showButtonPanel: true,
            numberOfMonths: 2 // Show two months at once
        });
    });
    </script>
</body>
</html>
