document.addEventListener('DOMContentLoaded', async () => {
    const params = new URLSearchParams(window.location.search);
    const propertyId = params.get('id');

    const propertyDetailsElement = document.getElementById('property-details');

    try {
        const property = await fetchPropertyDetails(propertyId);  // Fetch data from the API

        propertyDetailsElement.innerHTML = `
            <h2>${property.title}</h2>
            <p>${property.description}</p>
            <p>Price per night: $${property.price_per_night}</p>
            <p>Max Guests: ${property.max_guests}</p>
        `;
    } catch (error) {
        console.error('Error loading property details:', error);
        propertyDetailsElement.innerHTML = '<p>Failed to load property details. Please try again later.</p>';
    }
});