
document.addEventListener('DOMContentLoaded', function () {
    const searchBtn = document.getElementById('searchBtn');

    searchBtn.addEventListener('click', function () {
        const dateRange = document.getElementById('dateRange').value;
        const town = document.getElementById('town').value;
        const adults = document.getElementById('adults').value;
        const bathrooms = document.getElementById('bathrooms').value;
        const bedrooms = document.getElementById('bedrooms').value;

        // Debugging: Log data to be sent
        console.log("Sending search data:", { dateRange, town, adults, bathrooms, bedrooms });

        // AJAX request to fetch search results
        fetch('search_properties.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ dateRange, town, adults, bathrooms, bedrooms })
        })
        .then(response => response.json())
        .then(data => {
            const propertyList = document.getElementById('propertyList');
            propertyList.innerHTML = ''; // Clear previous results

            if (data.length === 0) {
                propertyList.innerHTML = '<p>No properties found matching your search criteria.</p>';
            } else {
                // Display new results
                data.forEach(property => {
                    const propertyCard = document.createElement('div');
                    propertyCard.classList.add('property-card');
                    propertyCard.innerHTML = `
                        <img src="${property.image}" alt="Property Image" class="property-image">
                        <div class="property-info">
                            <h2>${property.title}</h2>
                            <p class="property-location">${property.location}</p>
                            <p class="property-amenities">${property.amenities}</p>
                            <p class="property-price">From €${property.price} / night</p>
                            <a href="property_details.php?id=${property.id}" class="info-button">+ INFO</a>
                        </div>
                    `;
                    propertyList.appendChild(propertyCard);
                });
            }
        })
        .catch(error => {
            console.error('Error fetching properties:', error);
            document.getElementById('propertyList').innerHTML = '<p>Failed to load properties. Please try again later.</p>';
        });
    });
});
