<?php
// Include config file
require 'config.php';

// Fetch properties
try {
    $stmt = $pdo->query("SELECT * FROM properties");
    $properties = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    die("Error fetching properties: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Properties for Rent</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <header>
        <h1>Available Properties</h1>
    </header>
    <main id="property-list">
        <?php if ($properties): ?>
            <?php foreach ($properties as $property): ?>
                <div class="property-item">
                    <h2><?php echo htmlspecialchars($property['title']); ?></h2>
                    <p><?php echo htmlspecialchars($property['description']); ?></p>
                    <p>Price per night: $<?php echo htmlspecialchars($property['price_per_night']); ?></p>
                    <a href="property_details.php?id=<?php echo htmlspecialchars($property['property_id']); ?>">View Details</a>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <p>No properties available at the moment.</p>
        <?php endif; ?>
    </main>
</body>
</html>
