<?php
require 'config.php';

// Fetch property details
if (!isset($_GET['id'])) {
    die("Property ID not specified.");
}

$propertyId = (int)$_GET['id'];
try {
    $stmt = $pdo->prepare("SELECT * FROM properties WHERE property_id = ?");
    $stmt->execute([$propertyId]);
    $property = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$property) {
        die("Property not found.");
    }
} catch (Exception $e) {
    die("Error fetching property details: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($property['title']); ?></title>
    <link rel="stylesheet" href="css/style.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
</head>
<body>
    <div class="property-gallery">
        <!-- Displaying a static set of images for now; replace URLs with dynamic ones if needed -->
        <img src="https://via.placeholder.com/800x400" alt="Property Image 1">
        <img src="https://via.placeholder.com/800x400" alt="Property Image 2">
        <img src="https://via.placeholder.com/800x400" alt="Property Image 3">
    </div>

    <div class="property-details-container">
        <div class="property-info">
            <h1><?php echo htmlspecialchars($property['title']); ?></h1>
            <p class="location"><?php echo htmlspecialchars($property['location']); ?></p>
            
            <div class="amenities">
                <span>Max Guests: <?php echo htmlspecialchars($property['max_guests']); ?></span>
                <span>Bedrooms: <?php echo htmlspecialchars($property['bedrooms']); ?></span>
                <span>Bathrooms: <?php echo htmlspecialchars($property['bathrooms']); ?></span>
                <span>Price per night: €<?php echo htmlspecialchars($property['price_per_night']); ?></span>
                <span>Wi-Fi: <?php echo $property['wifi'] ? 'Available' : 'Not Available'; ?></span>
            </div>

            <h2>Description</h2>
            <p><?php echo nl2br(htmlspecialchars($property['description'])); ?></p>
        </div>

        <div class="booking-section">
            <h3>Book this Property</h3>
            <form id="booking-form" method="POST" action="book_property.php">
        <input type="hidden" name="property_id" value="<?php echo $propertyId; ?>">
                <label for="check-in">Check-in Date:</label>
                <input type="text" id="check-in" name="check_in" placeholder="Check-in Date">
                
                <label for="check-out">Check-out Date:</label>
                <input type="text" id="check-out" name="check_out" placeholder="Check-out Date">
                
                <label for="guests">Number of Guests:</label>
                <input type="number" id="guests" name="guests" required min="1" max="<?php echo htmlspecialchars($property['max_guests']); ?>">

                <button type="submit">Book Now</button>
            </form>
        </div>
    </div>

    <div class="property-map">
        <h2>Location</h2>
        <!-- Embed Google Maps iframe (replace lat and lng with dynamic coordinates if available) -->
        <iframe src="https://www.google.com/maps/embed/v1/place?key=YOUR_API_KEY&q=<?php echo urlencode($property['location']); ?>" width="100%" height="400" frameborder="0" style="border:0" allowfullscreen></iframe>
    </div>

    <script>
        // Flatpickr initialization for date fields
        flatpickr("#check-in", { dateFormat: "d.m.Y" });
        flatpickr("#check-out", { dateFormat: "d.m.Y" });
    </script>
</body>
</html>
