
<?php
require 'config.php';
header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);

// Extract filters
$dateRange = $input['dateRange'];
$town = $input['town'];
$adults = $input['adults'];
$bathrooms = $input['bathrooms'];
$bedrooms = $input['bedrooms'];

// Debugging: Output received data
error_log("Search parameters received: DateRange=$dateRange, Town=$town, Adults=$adults, Bathrooms=$bathrooms, Bedrooms=$bedrooms");

// Build SQL query with filters
$query = "SELECT * FROM properties WHERE 1=1";
$params = [];

// Apply filters if set
if ($town) {
    $query .= " AND town = ?";
    $params[] = $town;
}
if ($adults) {
    $query .= " AND max_guests >= ?";
    $params[] = $adults;
}
if ($bathrooms) {
    $query .= " AND bathrooms = ?";
    $params[] = $bathrooms;
}
if ($bedrooms) {
    $query .= " AND bedrooms = ?";
    $params[] = $bedrooms;
}

$stmt = $pdo->prepare($query);
$stmt->execute($params);

$properties = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Debugging: Output properties fetched
error_log("Properties fetched: " . json_encode($properties));

echo json_encode($properties);
?>
